/** Contains static methods linearSearch, LinearSearch1,
    min, binarySearch, equal, and numberLess. */
public class Searches {
   /** Return an index i that truthifies R:<br>
      (1) h &lt;= i &lt;= k<br>
      (2) x not in b[h..i-1]<br>
      (3) i = k  or  x = b[i]
      */
   public static int linearSearch(int[] b, int h, int k, int x) {
      int i= h;
      // {inv P:  h <= i <= k  and  x not in b[h..i-1]
      while (i != k  && x != b[i])
         {i= i+1;}
      return i;
   }
   
   /** Return an index i that truthifies R:<br>
      (1) h &lt;= i &lt;= k<br>
      (2) x not in b[h..i-1]<br>
      (3) i = k  or  x = b[i]
      */
   public static int linearSearch1(int[] b, int h, int k, int x) {
      // {inv P:  h <= i <= k  and  x not in b[h..i-1]}
      for (int i= h; i != k; i++) {
         if (x == b[i])
            {return i;}
      }
      return k;
   }
   
   /** Given h < k, return the position of the minimum value of b[h..k] */
   public static int min(int[] b, int h, int k) {
      int p= h; // will contain index of minimum
      int i= h;
      // {inv: b[p] is the minimum of b[h..i]}
      while (i!= k) {
         i= i+1;
         if (b[i] < b[p])
            {p= i;}
      }
      return p;
   }
   
   /** Assume virtual elements b[-1] = -infinity and
       b.[b.length] = +infinity; Return a value
       i that satisfies R: b[i] <= x < b[i+1] */
   public static int binarySearch(int[] b, int x) {
      int i= -1; int j= b.length;
      // {P:b[i] <= x < b[j] and -1 <= i < j <= b.length}
      while (j != i+1) {
         int e= (i+j)/2;
         // {-1 <= i < e < j <= b.length}
         if (b[e] <= x) i= e;
         else j= e;
      }
      return i;
   }
   
   /** = "arrays b and c are equal" */
   public static boolean equal(int[] b, int[] c) {
      if (b == c) return true;
      if (b == null || c == null) return false;
      if (b.length != c.length) return false;
      // Return false if b[i] != c[i] for some i
         // inv: 0 <= i <= b.length  and  b[0..i-1] = c[0..i-1]
         for (int i= 0;  i != b.length; i++) {
            if (b[i] != c[i]) return false;
         }
      return true;
   }
   
   /** = no. elements of b that are less than c */
   public static int numberLess(int[] b, int v) {
      int c= 0; 
      // inv: 0 &lt;= i &lt;= b.length  and
      //      c = (no.elements of [0..b.i-1] less than v)
      for (int i= 0; i != b.length; i++) {
         if (b[i] < v)  
            c= c+1;
      }
      return c;
   }
   
   /** = the first index (r,c) in row-major order of element x in d
        (or the pair (d.length,0), if x is not in d) */
   public static Coordinates rowMajorSearch(int[][] d, int x) {
      // inv: x is not in d[0..r-1] and d[0..r][0..c-1]
      for (int r= 0; r != d.length; r++)
         for (int c= 0; c != d[r].length; c++) {
            if (x == d[r][c])
               return new Coordinates(r,c);
         }
      return new Coordinates(d.length,0);
   }
   
   /** The rows and columns of rectangular array d are in
      ascending order; x is guaranteed to be in d;
      Return an index-pair (r,c) of an occurrence of x in d */
   public static Coordinates saddlebackSearch(int[][] d, int x) {
      int r= 0;
      int c= d[0].length-1;
      // invariant: x is in b[r..][0..c]
      while (x != d[r][c]) {
         if (x > d[r][c]) r= r+1;
         else            c= c-1;
      }
   
      return new Coordinates(r,c);
   }


}
